
#ifndef _1_CRYS_ATP_TST_FLOW_DEFINES_Acceptance_h_H
#define _1_CRYS_ATP_TST_FLOW_DEFINES_Acceptance_h_H



/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#include "CRYS_ATP_TST_Defines.h"


#if TST_USE_FLOW_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 14 10:18:14 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_FLOW_Defines.h#1:incl:1
   *  \author Annag
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   

/************************ Defines *******************************/
/* number of cryptographic engines that support flow mechanism */
#define TST_FLOW_NUMBER_OF_SUPPORTED_ENGINES CRYS_FLOW_Size

#define TST_FLOW_COMMON_NUMBER_OF_VECTORS  1

#define TST_AES_Key128Size_InBytes  128/8
#define TST_AES_Key192Size_InBytes  192/8
#define TST_AES_Key256Size_InBytes  256/8
#define TST_AES_Key512Size_InBytes  512/8


/************************ Enums *********************************/
typedef enum
{
  CRYS_FLOW_AES  = 0,
  CRYS_FLOW_DES  = 1,
  CRYS_FLOW_HASH = 2,
  CRYS_FLOW_RC4  = 3,
  CRYS_FLOW_HMAC = 4,
  CRYS_FLOW_Size
}CRYS_FLOW_Engine_t;

/************************ Typedefs  *****************************/
/************************ Structs  ******************************/

/* struct that contains common flow data */
typedef struct TST_FLOW_TestCommonDataStruct{	
	/* input interrupt id */
	DxUint32_t                  inputInterruptId;

	/* output interrupt id */
	DxUint32_t                  outputInterruptId;

	/* if the data in the buffers are in words and not bytes */ 
	DxUint32_t                  wordsBuffersOrderFlag;

	/* number of input buffers */
	DxUint32_t                  inputBuffersArraySize;

	/* flag if  endian order of the input buffers is big */
	DxUint32_t                  inputBigEndianOrderFlag;

	/* number of input buffers */
	DxUint32_t                  outputBuffersArraySize;

	/* flag if  endian order of the output buffers is big */
	DxUint32_t                  outputBigEndianOrderFlag;
} TST_FLOW_TestCommonDataStruct;



/************************ Public Variables **********************/

/************************ Public Functions **********************/


#ifdef __cplusplus
}
#endif

#endif

#endif
